<?php

/**
 * BlueOnyx API
 *
 * BlueOnyx 5210R API interface module for WHMCS
 *
 * @package   BlueOnyx base-api.mod
 * @author    Michael Stauber
 * @copyright Copyright (c) 2014-2022 Michael Stauber, SOLARSPEED.NET
 * @link      http://www.solarspeed.net
 * @license   http://devel.blueonyx.it/pub/BlueOnyx/licenses/SUN-modified-BSD-License.txt
 * @version   2.5
 *
 * @info      Creation of this module was sponsored by VIRTBIZ Internet Services: http://www.virtbiz.com
 *
 */

function blueonyx5210r_ConfigOptions() {

    # Should return an array of the module options for each product - maximum of 24

    $configarray = array(

        // #1
        "WHM Package Name" => array( 
            "Type" => "text", 
            "Size" => "25",
        ),
        // #2
        "username" => array (
            "FriendlyName" => "UserName",
            "Type" => "text", # Text Box
            "Size" => "15", # Defines the Field Width
            "Description" => "",
            "Default" => "",
        ),
        // #3
        "password" => array (
            "FriendlyName" => "Password",
            "Type" => "password", # Password Field
            "Size" => "15", # Defines the Field Width
            "Description" => "",
            "Default" => "",
        ),
        // #4
        "usessl" => array (
            "FriendlyName" => "GUI via SSL",
            "Type" => "yesno", # Yes/No Checkbox
            "Description" => "Tick to use secure connections",
        ),
        // #5
        "disk" => array (
            "FriendlyName" => "Disk Space",
            "Type" => "text", # Text Box
            "Description" => "MB",
            "Size" => "6",
            "Default" => "200",
        ),
        // #6
        "users" => array (
            "FriendlyName" => "Maximum Users",
            "Type" => "text", # Text Box
            "size" => "4",
            "Description" => "",
            "Default" => "25",
        ),
        // #7
        "auto-dns" => array (
            "FriendlyName" => "Automatic DNS",
            "Type" => "yesno",
            "Description" => "Use automatic DNS",
        ),
        // #8
        "jsp" => array (
            "FriendlyName" => "JSP",
            "Type" => "yesno",
            "Description" => "Enable JSP",
        ),
        // #9
        "PHP" => array (
            "FriendlyName" => "PHP",
            "Type" => "dropdown", # Dropdown Choice of Options
            "Options" => "No,Yes,ModRUID,suPHP,FPM",
            "Description" => "",
            "Default" => "FPM",
        ),
        // #10
        "ssi" => array (
            "FriendlyName" => "SSI",
            "Type" => "yesno",
            "Description" => "Allow Server Side Includes",
        ),
        // #11
        "PHPVersion" => array (
            "FriendlyName" => "PHP Version",
            "Type" => "dropdown", # Dropdown Choice of Options
            "Options" => "PHPOS,PHP53,PHP54,PHP55,PHP56,PHP70,PHP71,PHP72,PHP73,PHP74,PHP80,PHP81,PHP82,PHP83",
            "Description" => "Only if PHP method 'suPHP' or 'FPM' is used and a matching PHP PKG is installed on the BlueOnyx server. Defaults to OS provided PHP.",
            "Default" => "PHPOS",
        ),
        // #12
        "cgi" => array (
            "FriendlyName" => "CGI",
            "Type" => "yesno",
            "Description" => "CGI/Perl enabled",
        ),

        // #13
        "MySQL" => array (
            "FriendlyName" => "MySQL Databases",
            "Type" => "dropdown", # Dropdown Choice of Options
            "Options" => "0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20",
            "Description" => "# of allowed MySQL/MariaDB databases",
            "Default" => "1",
        ),
        // #14    
        "ftp" => array (
            "FriendlyName" => "FTP for non-siteAdmin",
            "Type" => "yesno",
            "Description" => "Regular users can use FTP, too.",
        ),
        // #15
        "userwebs" => array (
            "FriendlyName" => "User owned web's",
            "Type" => "yesno",
            "Description" => "Users have own /web dir. Not compatible with suPHP or FPM.",
        ),
        // #16
        "forwardemail" => array (
            "FriendlyName" => "Email Forwarding",
            "Type" => "yesno",
            "Description" => "Forward emails to siteAdmin to clients WHMCS email-address.",
        ),
        // #17
        "shell" => array (
            "FriendlyName" => "Shell Access",
            "Type" => "dropdown", # Dropdown Choice of Options
            "Options" => "None,Chrooted (SFTP SCP RSYNC),Chrooted (Shell SFTP SCP RSYNC),Full Shell Access",
            "Description" => "",
            "Default" => "None",
        ),
        // #18
        "subdomains" => array (
            "FriendlyName" => "Sub-Domains",
            "Type" => "yesno",
            "Description" => "Enable subdomains.",
        ),
        // #19
        "comments" => array (
            "FriendlyName" => "Notes",
            "Type" => "textarea", # Textarea
            "Rows" => "3", # Number of Rows
            "Cols" => "50", # Number of Columns
            "Description" => "Enter notes here",
            "Default" => "",
        ),
        // #20
        "subdomainsMax" => array (
            "FriendlyName" => "# of subdomains",
            "Type" => "text", # Text Box
            "Description" => "",
            "Size" => "3",
            "Default" => "1",
        ),
    );
    return $configarray;

}

function blueonyx5210r_CreateAccount($params) {

    # ** The variables listed below are passed into all module functions **

    $serviceid = $params["serviceid"]; # Unique ID of the product/service in the WHMCS Database
    $pid = $params["pid"]; # Product/Service ID
    $producttype = $params["producttype"]; # Product Type: hostingaccount, reselleraccount, server or other
    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];
    $customfields = $params["customfields"]; # Array of custom field values for the product
    $configoptions = $params["configoptions"]; # Array of configurable option values for the product

    # Product module option settings from ConfigOptions array above
    $disk = $params["configoption5"];
    $users = $params["configoption6"];
    if ($params["configoption7"] == "on") {
      $auto_dns = "1";
    }
    else {
      $auto_dns = "0";
    }
    if ($params["configoption8"] == "on") {
      $jsp = "1";
    }
    else {
      $jsp = "0";
    }
    $php = $params["configoption9"];

    if ($params["configoption10"] == "on") {
      $ssi = "1";
    }
    else {
      $ssi = "0";
    }

    $php_version = $params["configoption11"];

    if ($params["configoption12"] == "on") {
      $cgi = "1";
    }
    else {
      $cgi = "0";
    }

    if (($params["configoption13"] > "0") && ($params["configoption13"] < "21")) {
      $mysql = $params["configoption13"];
    }
    else {
      $mysql = "0";
    }

    if ($params["configoption14"] == "on") {
      $ftp = "1";
    }
    else {
      $ftp = "0";
    }

    if ($params["configoption15"] == "on") {
      $userwebs = "1";
    }
    else {
      $userwebs = "0";
    }

    if ($params["configoption16"] == "on") {
      $forwardemail = "1";
    }
    else {
      $forwardemail = "0";
    }

    $shell = "0";
    $shellOptions = array('None', 'Chrooted (SFTP SCP RSYNC)', 'Chrooted (Shell SFTP SCP RSYNC)', 'Full Shell Access');
    if (in_array($params["configoption17"], $shellOptions)) {
        if ($params["configoption17"] == 'Chrooted (SFTP SCP RSYNC)') {
            $shell = "1";
        }
        elseif ($params["configoption17"] == 'Chrooted (Shell SFTP SCP RSYNC)') {
            $shell = "2";
        }
        elseif ($params["configoption17"] == 'Full Shell Access') {
            $shell = "3";
        }
        else {
            $shell = "0";
        }
    }

    if ($params["configoption18"] == "on") {
      $subdomains = "1";
    }
    else {
      $subdomains = "0";
    }

    $comments = $params["configoption19"];

    $subdomainsMax = $params["configoption20"];

    if ($users <= '1') { $users = '1'; }
    if ($subdomains == '') { $subdomains = '0'; }
    if ($subdomainsMax == '') { $subdomainsMax = '0'; }
    if (($php == 'suPHP') || ($php == 'FPM') && ($userwebs == '1')) { $userwebs = '0'; }

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverhostname = $params["serverhostname"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serveraccesshash = $params["serveraccesshash"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

    $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "disk" => $disk,
          "users" => $users,
          "auto_dns" => $auto_dns,
          "jsp" => $jsp,
          "php" => $php,
          "php_version" => $php_version,
          "mysql" => $mysql,
          "cgi" => $cgi,
          "ssi" => $ssi,
          "ftp" => $ftp,
          "userwebs" => $userwebs,
          "shell" => $shell,
          "subdomains" => $subdomains,
          "subdomainsMax" => $subdomainsMax,
          "forwardemail" => $forwardemail,
          "comments" => $comments,
          "clientsdetails" => json_encode($clientsdetails));

    $payload_json = json_encode($payload);

    $data = array("action" => "create",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = blueonyx5210r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    } else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;
}

function blueonyx5210r_TerminateAccount($params) {

    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

      $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "clientsdetails" => json_encode($clientsdetails));

    $payload_json = json_encode($payload);

    $data = array("action" => "destroy",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = blueonyx5210r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    } else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;

}

function blueonyx5210r_SuspendAccount($params) {

    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

      $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "clientsdetails" => json_encode($clientsdetails));

    $payload_json = json_encode($payload);

    $data = array("action" => "suspend",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = blueonyx5210r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    } else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;

}

function blueonyx5210r_UnsuspendAccount($params) {

    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

      $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "clientsdetails" => json_encode($clientsdetails));

    $payload_json = json_encode($payload);

    $data = array("action" => "unsuspend",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = blueonyx5210r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    } else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;

}

function blueonyx5210r_ChangePassword($params) {

    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

      $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "clientsdetails" => json_encode($clientsdetails));

    $payload_json = json_encode($payload);

    $data = array("action" => "changepass",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = blueonyx5210r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    } else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;

}

function blueonyx5210r_ChangePackage($params) {

    # ** The variables listed below are passed into all module functions **

    $serviceid = $params["serviceid"]; # Unique ID of the product/service in the WHMCS Database
    $pid = $params["pid"]; # Product/Service ID
    $producttype = $params["producttype"]; # Product Type: hostingaccount, reselleraccount, server or other
    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];
    $customfields = $params["customfields"]; # Array of custom field values for the product
    $configoptions = $params["configoptions"]; # Array of configurable option values for the product

    # Product module option settings from ConfigOptions array above
    $disk = $params["configoption5"];
    $users = $params["configoption6"];
    if ($params["configoption7"] == "on") {
      $auto_dns = "1";
    }
    else {
      $auto_dns = "0";
    }
    if ($params["configoption8"] == "on") {
      $jsp = "1";
    }
    else {
      $jsp = "0";
    }
    $php = $params["configoption9"];

    if ($params["configoption10"] == "on") {
      $ssi = "1";
    }
    else {
      $ssi = "0";
    }

    $php_version = $params["configoption11"];

    if ($params["configoption12"] == "on") {
      $cgi = "1";
    }
    else {
      $cgi = "0";
    }

    if (($params["configoption13"] > "0") && ($params["configoption13"] < "21")) {
      $mysql = $params["configoption13"];
    }
    else {
      $mysql = "0";
    }

    if ($params["configoption14"] == "on") {
      $ftp = "1";
    }
    else {
      $ftp = "0";
    }

    if ($params["configoption15"] == "on") {
      $userwebs = "1";
    }
    else {
      $userwebs = "0";
    }

    if ($params["configoption16"] == "on") {
      $forwardemail = "1";
    }
    else {
      $forwardemail = "0";
    }

    $shell = "0";
    $shellOptions = array('None', 'Chrooted (SFTP SCP RSYNC)', 'Chrooted (Shell SFTP SCP RSYNC)', 'Full Shell Access');
    if (in_array($params["configoption17"], $shellOptions)) {
        if ($params["configoption17"] == 'Chrooted (SFTP SCP RSYNC)') {
            $shell = "1";
        }
        elseif ($params["configoption17"] == 'Chrooted (Shell SFTP SCP RSYNC)') {
            $shell = "2";
        }
        elseif ($params["configoption17"] == 'Full Shell Access') {
            $shell = "3";
        }
        else {
            $shell = "0";
        }
    }

    if ($params["configoption18"] == "on") {
      $subdomains = "1";
    }
    else {
      $subdomains = "0";
    }

    $comments = $params["configoption19"];

    $subdomainsMax = $params["configoption20"];

    if ($users <= '1') { $users = '1'; }
    if ($subdomains == '') { $subdomains = '0'; }
    if ($subdomainsMax == '') { $subdomainsMax = '0'; }
    if (($php == 'suPHP') || ($php == 'FPM') && ($userwebs == '1')) { $userwebs = '0'; }

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serveraccesshash = $params["serveraccesshash"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

      $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "disk" => $disk,
          "users" => $users,
          "auto_dns" => $auto_dns,
          "jsp" => $jsp,
          "php" => $php,
          "php_version" => $php_version,
          "mysql" => $mysql,
          "cgi" => $cgi,
          "ssi" => $ssi,
          "ftp" => $ftp,
          "userwebs" => $userwebs,
          "shell" => $shell,
          "subdomains" => $subdomains,
          "subdomainsMax" => $subdomainsMax,
          "forwardemail" => $forwardemail,
          "comments" => $comments,
          "clientsdetails" => json_encode($clientsdetails));

    $payload_json = json_encode($payload);

    $data = array("action" => "modify",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = blueonyx5210r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    } else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;
}

function blueonyx5210r_ClientArea($params) {

  if ($params["serversecure"] == TRUE) {
        // <input type="hidden" name="redirect_target" value="/swupdate/news" />
        $code = '<form action="https://'.$params["serverhostname"].':81/api/apilogin" method="post" target="_blank">
            <input type="hidden" name="username_field" value="'.$params["username"].'" />
            <input type="hidden" name="password_field" value="'.$params["password"].'" />
            <input type="hidden" name="secureConnect" id="yes" value="1"  checked="checked">
            <input type="submit" value="Login to Control Panel" />
            </form>';
        return $code;
  }
  else {
      // <input type="hidden" name="redirect_target" value="/swupdate/news" /> 
      $code = '<form action="http://'.$params["serverhostname"].':444/api/apilogin" method="post" target="_blank">
            <input type="hidden" name="username_field" value="'.$params["serverusername"].'" />
            <input type="hidden" name="password_field" value="'.$params["serverpassword"].'" />
            <input type="hidden" name="secureConnect" id="no" value="0">
            <input type="submit" value="Login to Control Panel" />
          </form>';
      return $code;
  }
}

function blueonyx5210r_AdminLink($params) {

  # Additional variables if the product/service is linked to a server
  $server = $params["server"]; # True if linked to a server
  $serverid = $params["serverid"];
  $serverip = $params["serverip"];
  $serverusername = $params["serverusername"];
  $serverpassword = $params["serverpassword"];
  $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

  # Code to perform action goes here:
  if ($serversecure == "on") {
    $url = "https://" . $serverip . ":81/api/index";
  }
  else {
    $url = "http://" . $serverip . ":444/api/index";
  }

  $data = array("action" => "status",
        "login" => $serverusername,
        "pass" => $serverpassword);

  // Get the AM-Status details. But set a 8 second timeout, so that in case of a server
  // outage we don't hang WHMCS for a full 900 seconds:
  $post_results = blueonyx5210r_post_to_url($url, $data, "8");

  if ($post_results == "G") {
    $serv_status = "AM-Status: OK";
  }
  elseif ($post_results == "Y") {
    $serv_status = "AM-Status: Fault";
  }
  elseif ($post_results == "R") {
    $serv_status = "AM-Status: Problem";
  }
  else {
    $serv_status = "AM-Status: Unknown";
  }

  if ($params["serversecure"] == TRUE) {
      $code = '
        <table cellspacing="0" cellpadding="5" border="0">
        <tbody>
            <tr>
            <td><form action="https://'.$params["serverhostname"].':81/api/apilogin" method="post" target="_blank">
                <input type="hidden" name="redirect_target" value="/vsite/vsiteList" /> 
                <input type="hidden" name="username_field" value="'.$params["serverusername"].'" />
                <input type="hidden" name="password_field" value="'.$params["serverpassword"].'" />
                <input type="hidden" name="secureConnect" id="yes" value="1"  checked="checked">
                <input type="submit" value="Login to Control Panel (SSL)" />
                  </form></td>
            <td>' . $serv_status . '</td>
            </tr>
        </tbody>
        </table>';
      return $code;
  }
  else {
      $code = '
        <table cellspacing="0" cellpadding="5" border="0">
        <tbody>
            <tr>
            <td><form action="http://'.$params["serverhostname"].':444/api/apilogin" method="post" target="_blank">
                <input type="hidden" name="redirect_target" value="/vsite/vsiteList" /> 
                <input type="hidden" name="username_field" value="'.$params["serverusername"].'" />
                <input type="hidden" name="password_field" value="'.$params["serverpassword"].'" />
                <input type="hidden" name="secureConnect" id="no" value="0">
                <input type="submit" value="Login to Control Panel" />
                  </form></td>
            <td>' . $serv_status . '</td>
            </tr>
        </tbody>
        </table>';
      return $code;
  }
}

function blueonyx5210r_LoginLink($params) {

    if ($params["serversecure"] == TRUE) {
        $code = '<form action="https://'.$params["serverhostname"].':81/api/apilogin" method="post" target="_blank">
                    <input type="hidden" name="redirect_target" value="/vsite/vsiteList" /> 
                    <input type="hidden" name="username_field" value="'.$params["serverusername"].'" />
                    <input type="hidden" name="password_field" value="'.$params["serverpassword"].'" />
                    <input type="hidden" name="secureConnect" id="yes" value="1"  checked="checked">
                    <input type="submit" class="btn btn-primary" value="Login to Control Panel (SSL)" /></form>';
        echo '<div class="col-sm-7">' . $code . '</div>';
    }
    else {
        $code = '<form action="http://'.$params["serverhostname"].':444/api/apilogin" method="post" target="_blank">
                    <input type="hidden" name="redirect_target" value="/vsite/vsiteList" /> 
                    <input type="hidden" name="username_field" value="'.$params["serverusername"].'" />
                    <input type="hidden" name="password_field" value="'.$params["serverpassword"].'" />
                    <input type="hidden" name="secureConnect" id="no" value="0"  checked="checked">
                    <input type="submit" class="btn btn-primary" value="Login to Control Panel (non-SSL)" /></form>';
        echo '<div class="col-sm-7">' . $code . '</div>';
    }

}

function blueonyx5210r_reboot($params) {

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

    $data = array("action" => "reboot",
          "login" => $serverusername,
          "pass" => $serverpassword);

    $post_results = blueonyx5210r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    } else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;

}

function blueonyx5210r_shutdown($params) {

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

    $data = array("action" => "shutdown",
          "login" => $serverusername,
          "pass" => $serverpassword);

    $post_results = blueonyx5210r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    } else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;

}

function blueonyx5210r_ClientAreaCustomButtonArray() {
    $buttonarray = array(
        //"Button 1 Display Value" => "buttonOneFunction",
    );
    return $buttonarray;
}

function blueonyx5210r_buttonOneFunction(array $params) {
    try {
        // Call the service's function, using the values provided by WHMCS in
        // `$params`.
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'provisioningmodule',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}

function blueonyx5210r_AdminCustomButtonArray() {
    $buttonarray = array(
     //"Reboot Server" => "reboot",
     //"Shutdown Server" => "shutdown",
    );
    return $buttonarray;
}

function blueonyx5210r_extrapage($params) {
    $pagearray = array(
    );
    return $pagearray;
}

function blueonyx5210r_UsageUpdate($params) {

    $serverid = $params['serverid'];
    $serverhostname = $params['serverhostname'];
    $serverip = $params['serverip'];
    $serverusername = $params['serverusername'];
    $serverpassword = $params['serverpassword'];
    $serveraccesshash = $params['serveraccesshash'];
    $serversecure = $params['serversecure'];

    # Run connection to retrieve usage for all domains/accounts on $serverid

    # Now loop through results and update DB

    foreach ($results AS $domain=>$values) {
        update_query("UsageUpdate",array(
         "diskused"=>$values['diskusage'],
         "disklimit"=>$values['disklimit'],
         "bwused"=>$values['bwusage'],
         "bwlimit"=>$values['bwlimit'],
         "lastupdate"=>"now()",
        ),array("server"=>$serverid,"domain"=>$values['domain']));
    }

}

function blueonyx5210r_AdminServicesTabFields($params) {
    
    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];
    
    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config
    
    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }
    
    $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "clientsdetails" => json_encode($clientsdetails));
    
    $payload_json = json_encode($payload);
    
    $data = array("action" => "vsitestatus",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);
    
    $post_results = blueonyx5210r_post_to_url($url, $data);
    $pr_decoded = (array) json_decode($post_results, true);

    if (isset($pr_decoded['CHECKSTATUS'])) {
        $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }
    
    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
    
        $VsiteDiskUsage = '';
        if (isset($pr_decoded['VsiteDiskUsage'])) {
            $VsiteDiskUsage = $pr_decoded['VsiteDiskUsage'];
        }
        $UserCnt = '';
        if (isset($pr_decoded['UserCnt'])) {
            $UserCnt = $pr_decoded['UserCnt'];
        }
        $vsitePHP = 'PHPOS';
        if (isset($pr_decoded['vsitePHP'])) {
            $vsitePHP = $pr_decoded['vsitePHP'];
        }
        $PHPType = 'Disabled';
        if (isset($pr_decoded['PHPType'])) {
            $PHPType = $pr_decoded['PHPType'];
        }

        $MySQL_line = 'Disabled';
        if ((isset($pr_decoded['VsiteMySQL'])) && (isset($pr_decoded['VsiteMaxDBs'])) && (isset($pr_decoded['VsiteDBs']))) {
            if ($pr_decoded['VsiteMySQL'] == '1') {
                $MySQL_line = 'Enabled. ' . $pr_decoded['VsiteDBs'] . ' of ' . $pr_decoded['VsiteMaxDBs'] . ' allowed databases present.';
            }
        }

        $Subdomains_line = 'Disabled';
        if ((isset($pr_decoded['Vsite_subs'])) && (isset($pr_decoded['Vsite_subs_max'])) && (isset($pr_decoded['vsite_subs_present']))) {
            if ($pr_decoded['Vsite_subs'] == '1') {
                $Subdomains_line = 'Enabled. ' . $pr_decoded['vsite_subs_present'] . ' of ' . $pr_decoded['Vsite_subs_max'] . ' allowed subdomains present.';
            }
        }

        $SSL_line = 'Disabled';
        if ((isset($pr_decoded['Vsite_SSL'])) && (isset($pr_decoded['Vsite_SSL_orgName'])) && (isset($pr_decoded['vsite_SSL_expires']))) {
            if ($pr_decoded['Vsite_SSL'] == '1') {
                $SSL_line = 'Enabled. Organization: ' . $pr_decoded['Vsite_SSL_orgName'] . '. Expires: ' . $pr_decoded['vsite_SSL_expires'];
            }
        }

        $Vsite_Shell = 'Disabled';
        if (isset($pr_decoded['Vsite_Shell'])) {
            $Vsite_Shell = $pr_decoded['Vsite_Shell'];
        }

        // Garbage in, data out:
        $data_out = array(
            'Vsite Disk Usage' => htmlspecialchars($VsiteDiskUsage),
            'Users' => htmlspecialchars($UserCnt),
            'Users' => htmlspecialchars($UserCnt),
            'PHP' => htmlspecialchars($PHPType . " (" . $vsitePHP . ")"),
            'MySQL' => $MySQL_line,
            'Subdomains' => $Subdomains_line,
            'SSL' => $SSL_line,
            'Shell' => $Vsite_Shell
        );
    
        return $data_out;
        exit;
    }
    else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;
}

function blueonyx5210r_AdminServicesTabFieldsSave($params) {

    //update_query("mod_customtable",array(
    //    "var1"=>$_POST['modulefields'][0],
    //    "var2"=>$_POST['modulefields'][1],
    //    "var3"=>$_POST['modulefields'][2],
    //),array("serviceid"=>$params['serviceid']));
}

function blueonyx5210r_post_to_url($url, $data, $timeout="900") {
    $fields = '';
    foreach($data as $key => $value) { 
      $fields .= $key . '=' . $value . '&'; 
    }
    rtrim($fields, '&');

    $post = curl_init();

    curl_setopt($post, CURLOPT_URL, $url);
    curl_setopt($post, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($post, CURLOPT_TIMEOUT, $timeout); 
    curl_setopt($post, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($post, CURLOPT_POST, count($data));
    curl_setopt($post, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($post, CURLOPT_HEADER, false);
    curl_setopt($post, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($post, CURLOPT_SSL_VERIFYHOST, FALSE);
    curl_setopt($post, CURLOPT_HTTPHEADER, array('Connection: close'));

    $result = curl_exec($post);

    curl_close($post);
    $result = htmlspecialchars_decode(strip_tags($result), ENT_QUOTES);
    $string = str_replace(array("&lt;", "&gt;", '&amp;', '&#039;', '&quot;','&lt;', '&gt;', '&nbsp;'), array("<", ">",'&','\'','"','<','>', ' - '), htmlspecialchars_decode($result, ENT_NOQUOTES)); 
    //error_log($string);
    return $string;
}

/*
Copyright (c) 2014-2021 Michael Stauber, SOLARSPEED.NET
Copyright (c) 2014-2021 Team BlueOnyx, BLUEONYX.IT
All Rights Reserved.

1. Redistributions of source code must retain the above copyright 
   notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright 
   notice, this list of conditions and the following disclaimer in 
   the documentation and/or other materials provided with the 
   distribution.

3. Neither the name of the copyright holder nor the names of its 
   contributors may be used to endorse or promote products derived 
   from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN 
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.

You acknowledge that this software is not designed or intended for 
use in the design, construction, operation or maintenance of any 
nuclear facility.

*/
?>