<?php

/**
 * Aventurin{e} API
 *
 * Aventurin{e} 6109R API interface module for WHMCS
 *
 * @package   Aventurin{e} base-api.mod
 * @author    Michael Stauber
 * @copyright Copyright (c) 2014-2021 Michael Stauber, SOLARSPEED.NET
 * @link      http://www.solarspeed.net
 * @license   http://devel.blueonyx.it/pub/BlueOnyx/ISO/Aventurin%7be%7d/Aventurin%7be%7d-License-Agreement.pdf
 * @version   3.2
 *
 * @info      Creation of this module was sponsored by VIRTBIZ Internet Services: http://www.virtbiz.com
 *
 */

function aventurine6109r_ConfigOptions() {

    // Should return an array of the module options for each product - maximum of 24
    $configarray = array(

        // #1
        "WHM Package Name" => array( 
            "Type" => "text", 
            "Size" => "25",
        ),
        // #2
        "username" => array (
            "FriendlyName" => "UserName",
            "Type" => "text", # Text Box
            "Size" => "15", # Defines the Field Width
            "Description" => "Do not change.",
            "Default" => "root",
        ),
        // #3
        "OS_Template" => array (
            "FriendlyName" => "OS_Template",
            "Type" => "dropdown", # Dropdown Choice of Options
            "Options" => "almalinux-8-x86_64,blueonyx-5209R-x86_64,blueonyx-5210R-x86_64,centos-7-x86_64,centos-8-x86_64,debian-10.0-x86_64,ubuntu-20.04-x86_64",
            "Description" => "",
            "Default" => "blueonyx-5210R-x86_64",
        ),
        // #4
        "password" => array (
            "FriendlyName" => "Password",
            "Type" => "password", # Password Field
            "Size" => "18", # Defines the Field Width
            "Description" => "",
            "Default" => "",
        ),
        // #5
        "RAM" => array (
            "FriendlyName" => "RAM",
            "Type" => "text", # Text Box
            "Description" => "GB",
            "Size" => "6",
            "Default" => "4",
        ),
        // #6
        "usessl" => array (
            "FriendlyName" => "GUI via SSL",
            "Type" => "yesno", # Yes/No Checkbox
            "Description" => "Tick to use secure connections",
        ),
        // #7
        "SWAP" => array (
            "FriendlyName" => "SWAP",
            "Type" => "text", # Text Box
            "Description" => "GB",
            "Size" => "6",
            "Default" => "1",
        ),
        // #8
        "onboot" => array (
            "FriendlyName" => "onboot",
            "Type" => "yesno",
            "Description" => "VPS autostart",
        ),
        // #9
        "disk" => array (
            "FriendlyName" => "Disk Space",
            "Type" => "text", # Text Box
            "Description" => "GB",
            "Size" => "6",
            "Default" => "20",
        ),
        // #10
        "NETFILTER" => array (
            "FriendlyName" => "NETFILTER",
            "Type" => "dropdown",
            "Options" => "disabled,stateless,stateful,full",
            "Description" => "Allows/denies access to IPTables modules",
            "Default" => "full",
        ),
        // #11
        "NFS" => array (
            "FriendlyName" => "NFS",
            "Type" => "yesno",
            "Description" => "NFS Support",
        ),
        // #12
        "TUN" => array (
            "FriendlyName" => "NET: TUN/TAP",
            "Type" => "yesno",
            "Description" => "NET: TUN/TAP Support",
        ),
        // #13
        "cpuunits" => array (
            "FriendlyName" => "cpuunits",
            "Type" => "text", # Text Box
            "Description" => "# of CPUUNITS",
            "Size" => "6",
            "Default" => "10000",
        ),
        // #14
        "FUSE" => array (
            "FriendlyName" => "FUSE",
            "Type" => "yesno",
            "Description" => "'File System in User Space (FUSE)' Support",
        ),
        // #15
        "comments" => array (
            "FriendlyName" => "Notes",
            "Type" => "textarea", # Textarea
            "Rows" => "3", # Number of Rows
            "Cols" => "50", # Number of Columns
            "Description" => "Enter notes here",
            "Default" => "",
        ),
    );
    return $configarray;
}

function aventurine6109r_CreateAccount($params) {

    # ** The variables listed below are passed into all module functions **

    $serviceid = $params["serviceid"]; # Unique ID of the product/service in the WHMCS Database
    $pid = $params["pid"]; # Product/Service ID
    $producttype = $params["producttype"]; # Product Type: hostingaccount, reselleraccount, server or other
    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];
    $customfields = $params["customfields"]; # Array of custom field values for the product
    $configoptions = $params["configoptions"]; # Array of configurable option values for the product
    $comments = $params["configoption15"];

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serveraccesshash = $params["serveraccesshash"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

    // Poll Aventurin{e} for a free VPS IP address:
    $ipquery = array("action" => "getfreeip",
          "login" => $serverusername,
          "pass" => $serverpassword);

    $ipquery_result = aventurine6109r_post_to_url($url, $ipquery);

    if (!filter_var($ipquery_result, FILTER_VALIDATE_IP) === false) {
        $vps_ip = $ipquery_result;
    }
    else {
        $vps_ip = '';
        return "Error: No free IP addresses left on this Aventurin{e} node. " . json_encode($ipquery_result);
    }

    $payload = array("producttype" => $params["producttype"],
      "ipaddr" => $vps_ip,
      "domain" => $params["domain"],
      "username" => $params["username"],
      "password" => $params["password"],
      "OS_Template" => $params["configoption3"],
      "RAM" => $params["configoption5"],
      "usessl" => $params["configoption6"],
      "SWAP" => $params["configoption7"],
      "onboot" => $params["configoption8"],
      "disk" => $params["configoption9"],
      "NETFILTER" => $params["configoption10"],
      "NFS" => $params["configoption11"],
      "TUN" => $params["configoption12"],
      "cpuunits" => $params["configoption13"],
      "FUSE" => $params["configoption14"],
      "comments" => $comments,
      "clientsdetails" => json_encode($clientsdetails));

    // Create payload for Querys:
    $payload_json = json_encode($payload);

    // Poll Aventurin{e} to see if this User already exists:
    $userquery = array("action" => "getuser",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $userquery_result = aventurine6109r_post_to_url($url, $userquery);
    $user_check = json_decode($userquery_result);

    if ((isset($user_check->name)) && (isset($user_check->fullName)) && (isset($user_check->capLevels)) && (isset($user_check->description))) {
        // User already exists. Check deeper if it's the same user:
        $u_email = $params["clientsdetails"]["email"];
        if ((preg_match('/ManageVPS/', $user_check->capLevels)) && (preg_match("/$u_email/", $user_check->description))) {
            // Ok, this is is the same User! We use him and add the VPS to his account. Recreate payload to reflect this:
            $payload = array("producttype" => $params["producttype"],
              "ipaddr" => $vps_ip,
              "domain" => $params["domain"],
              "username" => $user_check->name,
              "password" => $params["password"],
              "OS_Template" => $params["configoption3"],
              "RAM" => $params["configoption5"],
              "usessl" => $params["configoption6"],
              "SWAP" => $params["configoption7"],
              "onboot" => $params["configoption8"],
              "disk" => $params["configoption9"],
              "NETFILTER" => $params["configoption10"],
              "NFS" => $params["configoption11"],
              "TUN" => $params["configoption12"],
              "cpuunits" => $params["configoption13"],
              "FUSE" => $params["configoption14"],
              "comments" => $comments,
              "clientsdetails" => json_encode($clientsdetails));

            // Create payload for Querys:
            $payload_json = json_encode($payload);

            // Update Username in WHMCS table:
            update_query( "tblhosting", array( "username" => $user_check->name ), array( "id" => $params['serviceid'] ) );
        }
        else {
            // Not the same User! We bail here:
            return "ERROR: Username '" . $user_check->name . "' is already taken on the target Aventurin{e} node. Please use another one.";
        }
    }

    // Create Query for setting up the VPS:
    $data = array("action" => "create",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = aventurine6109r_post_to_url($url, $data);

    if ($post_results == "success") {
        $successful = TRUE;
        if (!filter_var($ipquery_result, FILTER_VALIDATE_IP) === false) {
            $vps_ip = $ipquery_result;
            update_query( "tblhosting", array( "dedicatedip" => $vps_ip ), array( "id" => $params['serviceid'] ) );
        }
    }
    else {
        $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    }
    else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;
}

function aventurine6109r_TerminateAccount($params) {

    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

    $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "clientsdetails" => json_encode($clientsdetails));

    $payload_json = json_encode($payload);

    // Create query for 'destroy' transaction:
    $data = array("action" => "destroy",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = aventurine6109r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    } else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;

}

function aventurine6109r_SuspendAccount($params) {

    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

      $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "clientsdetails" => json_encode($clientsdetails));

    $payload_json = json_encode($payload);

    $data = array("action" => "suspend",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = aventurine6109r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    }
    else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;

}

function aventurine6109r_UnsuspendAccount($params) {

    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

      $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "clientsdetails" => json_encode($clientsdetails));

    $payload_json = json_encode($payload);

    $data = array("action" => "unsuspend",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = aventurine6109r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    }
    else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;

}

function aventurine6109r_ChangePassword($params) {

    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

      $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "clientsdetails" => json_encode($clientsdetails));

    $payload_json = json_encode($payload);

    $data = array("action" => "changepass",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = aventurine6109r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    }
    else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;

}

function aventurine6109r_ChangePackage($params) {

    # ** The variables listed below are passed into all module functions **

    $serviceid = $params["serviceid"]; # Unique ID of the product/service in the WHMCS Database
    $pid = $params["pid"]; # Product/Service ID
    $producttype = $params["producttype"]; # Product Type: hostingaccount, reselleraccount, server or other
    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];
    $customfields = $params["customfields"]; # Array of custom field values for the product
    $configoptions = $params["configoptions"]; # Array of configurable option values for the product
    $comments = $params["configoption15"];

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serveraccesshash = $params["serveraccesshash"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

      $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "OS_Template" => $params["configoption3"],
          "RAM" => $params["configoption5"],
          "usessl" => $params["configoption6"],
          "SWAP" => $params["configoption7"],
          "onboot" => $params["configoption8"],
          "disk" => $params["configoption9"],
          "NETFILTER" => $params["configoption10"],
          "NFS" => $params["configoption11"],
          "TUN" => $params["configoption12"],
          "cpuunits" => $params["configoption13"],
          "FUSE" => $params["configoption14"],
          "comments" => $comments,
          "clientsdetails" => json_encode($clientsdetails));

    $payload_json = json_encode($payload);

    $data = array("action" => "modify",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = aventurine6109r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    }
    else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;
}

function aventurine6109r_ClientArea($params) {

    $http = ($params['serversecure'] ? "https" : "http");
    $port = ($params['serversecure'] ? "81" : "444");
    $host = ($params['serverhostname'] ? $params['serverhostname'] : $params['serverip']);

    $code = '<form action="' . $http . '://'. $host .':'.$port.'/apilogin" method="post" target="_blank">
        <input type="hidden" name="redirect_target" value="/vserver/vserverList" />
        <input type="hidden" name="username_field" value="'.$params["username"].'" />
        <input type="hidden" name="password_field" value="'.$params["password"].'" />
        <input type="hidden" name="secureConnect" id="yes" value="1"  checked="checked">
        <input type="submit" value="Login to Control Panel" />
        </form>';
    return $code;
}

function aventurine6109r_AdminLink($params) {

  # Additional variables if the product/service is linked to a server
  $server = $params["server"]; # True if linked to a server
  $serverid = $params["serverid"];
  $serverip = $params["serverip"];
  $serverusername = $params["serverusername"];
  $serverpassword = $params["serverpassword"];
  $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

  # Code to perform action goes here:
  if ($serversecure == "on") {
    $url = "https://" . $serverip . ":81/api/index";
  }
  else {
    $url = "http://" . $serverip . ":444/api/index";
  }

  $data = array("action" => "status",
        "login" => $serverusername,
        "pass" => $serverpassword);

  // Get the AM-Status details. But set a 5 second timeout, so that in case of a server
  // outage we don't hang WHMCS for a full 900 seconds:
  $post_results = aventurine6109r_post_to_url($url, $data, "5");

  if ($post_results == "G") {
    $serv_status = "AM-Status: OK";
  }
  elseif ($post_results == "Y") {
    $serv_status = "AM-Status: Fault";
  }
  elseif ($post_results == "R") {
    $serv_status = "AM-Status: Problem";
  }
  else {
    $serv_status = "AM-Status: Unknown";
  }

  $http = ($params['serversecure'] ? "https" : "http");
  $port = ($params['serversecure'] ? "81" : "444");
  $host = ($params['serverhostname'] ? $params['serverhostname'] : $params['serverip']);

  $code = '
    <table cellspacing="0" cellpadding="5" border="0">
    <tbody>
        <tr>
        <td><form action="' . $http . '://'.$host.':'.$port.'/apilogin" method="post" target="_blank">
            <input type="hidden" name="redirect_target" value="/vserver/vserverList" /> 
            <input type="hidden" name="username_field" value="'.$params["serverusername"].'" />
            <input type="hidden" name="password_field" value="'.$params["serverpassword"].'" />
            <input type="hidden" name="secureConnect" id="yes" value="1"  checked="checked">
            <input type="submit" value="Login to Aventurin{e} GUI" />
              </form></td>
        <td>' . $serv_status . '</td>
        </tr>
    </tbody>
    </table>';
  return $code;
}

function aventurine6109r_LoginLink($params) {
    if ($params["serversecure"] == TRUE) {
        $code = '<form action="https://'.$params["serverhostname"].':81/apilogin" method="post" target="_blank">
                    <input type="hidden" name="redirect_target" value="/vserver/vserverList" /> 
                    <input type="hidden" name="username_field" value="'.$params["serverusername"].'" />
                    <input type="hidden" name="password_field" value="'.$params["serverpassword"].'" />
                    <input type="hidden" name="secureConnect" id="yes" value="1"  checked="checked">
                    <input type="submit" class="btn btn-primary" value="Login to Aventurin{e} GUI (SSL)" /></form>';
        echo '<div class="col-sm-7">' . $code . '</div>';
    }
    else {
        $code = '<form action="http://'.$params["serverhostname"].':444/apilogin" method="post" target="_blank">
                    <input type="hidden" name="redirect_target" value="/vserver/vserverList" /> 
                    <input type="hidden" name="username_field" value="'.$params["serverusername"].'" />
                    <input type="hidden" name="password_field" value="'.$params["serverpassword"].'" />
                    <input type="hidden" name="secureConnect" id="no" value="0"  checked="checked">
                    <input type="submit" class="btn btn-primary" value="Login to Aventurin{e} GUI (non-SSL)" /></form>';
        echo '<div class="col-sm-7">' . $code . '</div>';
    }
}

function aventurine6109r_reboot($params) {

    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

      $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "clientsdetails" => json_encode($clientsdetails));

    $payload_json = json_encode($payload);

    $data = array("action" => "reboot",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = aventurine6109r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    }
    else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;
}

function aventurine6109r_shutdown($params) {

    $domain = $params["domain"];
    $username = $params["username"];
    $password = $params["password"];
    $clientsdetails['firstname'] = $params["clientsdetails"]["firstname"];
    $clientsdetails['lastname'] = $params["clientsdetails"]["lastname"];
    $clientsdetails['email'] = $params["clientsdetails"]["email"];

    # Additional variables if the product/service is linked to a server
    $server = $params["server"]; # True if linked to a server
    $serverid = $params["serverid"];
    $serverip = $params["serverip"];
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $serversecure = $params["serversecure"]; # If set, SSL Mode is enabled in the server config

    # Code to perform action goes here:
    if ($serversecure == "on") {
      $url = "https://" . $serverip . ":81/api/index";
    }
    else {
      $url = "http://" . $serverip . ":444/api/index";
    }

      $payload = array("producttype" => $params["producttype"],
          "ipaddr" => $serverip,
          "domain" => $params["domain"],
          "username" => $params["username"],
          "password" => $params["password"],
          "clientsdetails" => json_encode($clientsdetails));

    $payload_json = json_encode($payload);

    $data = array("action" => "shutdown",
          "login" => $serverusername,
          "pass" => $serverpassword,
          "payload" => $payload_json);

    $post_results = aventurine6109r_post_to_url($url, $data);

    if ($post_results == "success") {
      $successful = TRUE;
    }
    else {
      $successful = FALSE;
    }

    if ($successful == TRUE) {
        // Vsite and User creation went through just fine:
        return $post_results;
        exit;
    }
    else {
        $result = "Error Message: ";
        $result .= $post_results;
        return $result;
        exit;
    }
    return $post_results;
    exit;
}

function aventurine6109r_ClientAreaCustomButtonArray() {
    $buttonarray = array();
    $buttonarray = array(
        "Reboot VPS" => "reboot",
        "Shutdown VPS" => "shutdown",
    );
    return $buttonarray;
}

function aventurine6109r_AdminCustomButtonArray() {
    $buttonarray = array(
        "Reboot VPS" => "reboot",
        "Shutdown VPS" => "shutdown",
    );
    return $buttonarray;
}

function aventurine6109r_extrapage($params) {
    $pagearray = array();
    return $pagearray;
}

function aventurine6109r_UsageUpdate($params) {

    $serverid = $params['serverid'];
    $serverhostname = $params['serverhostname'];
    $serverip = $params['serverip'];
    $serverusername = $params['serverusername'];
    $serverpassword = $params['serverpassword'];
    $serveraccesshash = $params['serveraccesshash'];
    $serversecure = $params['serversecure'];

    # Run connection to retrieve usage for all domains/accounts on $serverid

    # Now loop through results and update DB

    foreach ($results AS $domain=>$values) {
        update_query("tblhosting",array(
         "diskused"=>$values['diskusage'],
         "dislimit"=>$values['disklimit'],
         "bwused"=>$values['bwusage'],
         "bwlimit"=>$values['bwlimit'],
         "lastupdate"=>"now()",
        ),array("server"=>$serverid,"domain"=>$values['domain']));
    }

}

function aventurine6109r_AdminServicesTabFields($params) {

    $result = select_query("mod_customtable","",array("serviceid"=>$params['serviceid']));
    $data = mysql_fetch_array($result);
    $var1 = $data['var1'];
    $var2 = $data['var2'];
    $var3 = $data['var3'];
    $var4 = $data['var4'];

    $fieldsarray = array(
//     'Field 1' => '<input type="text" name="modulefields[0]" size="30" value="'.$var1.'" />',
//     'Field 2' => '<select name="modulefields[1]"><option>Val1</option</select>',
//     'Field 3' => '<textarea name="modulefields[2]" rows="2" cols="80">'.$var3.'</textarea>',
//     'Field 4' => $var4, # Info Output Only
    );
    return $fieldsarray;

}

function aventurine6109r_AdminServicesTabFieldsSave($params) {
    update_query("mod_customtable",array(
        "var1"=>$_POST['modulefields'][0],
        "var2"=>$_POST['modulefields'][1],
        "var3"=>$_POST['modulefields'][2],
    ),array("serviceid"=>$params['serviceid']));
}

function aventurine6109r_post_to_url($url, $data, $timeout="900") {
    $fields = '';
    foreach($data as $key => $value) { 
      $fields .= $key . '=' . $value . '&'; 
    }
    rtrim($fields, '&');

    $post = curl_init();

    curl_setopt($post, CURLOPT_URL, $url);
    curl_setopt($post, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($post, CURLOPT_TIMEOUT, $timeout); 
    curl_setopt($post, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($post, CURLOPT_POST, count($data));
    curl_setopt($post, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($post, CURLOPT_HEADER, false);
    curl_setopt($post, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($post, CURLOPT_SSL_VERIFYHOST, FALSE);
    curl_setopt($post, CURLOPT_HTTPHEADER, array('Connection: close'));

    $result = curl_exec($post);

    curl_close($post);
    $result = htmlspecialchars_decode(strip_tags($result), ENT_QUOTES);
    $string = str_replace(array("&lt;", "&gt;", '&amp;', '&#039;', '&quot;','&lt;', '&gt;', '&nbsp;'), array("<", ">",'&','\'','"','<','>', ' - '), htmlspecialchars_decode($result, ENT_NOQUOTES)); 
    error_log($string);
    return $string;
}

/*
Copyright (c) 2014-2021 Michael Stauber, SOLARSPEED.NET
All Rights Reserved.

1. Redistributions of source code must retain the above copyright 
   notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright 
   notice, this list of conditions and the following disclaimer in 
   the documentation and/or other materials provided with the 
   distribution.

3. Neither the name of the copyright holder nor the names of its 
   contributors may be used to endorse or promote products derived 
   from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN 
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.

You acknowledge that this software is not designed or intended for 
use in the design, construction, operation or maintenance of any 
nuclear facility.

*/
?>